/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.LegendaryHeroMaker;

import LegendaryCardMaker.CardMaker;
import LegendaryCardMaker.Icon;
import LegendaryCardMaker.LegendaryCardMaker;
import LegendaryCardMaker.LegendaryCardMakerFrame;
import LegendaryCardMaker.LegendaryHeroMaker.CardRarity;
import LegendaryCardMaker.LegendaryHeroMaker.GaussianFilter;
import LegendaryCardMaker.LegendaryHeroMaker.HeroCard;
import LegendaryCardMaker.LegendaryHeroMaker.MotionBlurOp;
import LegendaryCardMaker.WordDefinition;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class HeroMaker
extends CardMaker {
    public static int cardNameSizeTemplate = 40;
    public static String cardNameFontNameTemplate = null;
    public static int cardNameFontStyleTemplate = 0;
    public static Color cardNameColorTemplate = new Color(255, 186, 20);
    public static int heroNameSizeTemplate = 33;
    public static String heroNameFontNameTemplate = null;
    public static int heroNameFontStyleTemplate = 0;
    public static Color heroNameColorTemplate = new Color(255, 186, 20);
    public static int abilityTextSizeTemplate = 27;
    public static Color abilityTextColorTemplate = Color.BLACK;
    public static String abilityTextFontNameTemplate = null;
    public static int abilityTextFontStyleTemplate = 0;
    public static Color teamPowerUnderlayColorTemplate = Color.BLACK;
    public static int teamPowerBlurRadiusTemplate = 5;
    public static String nameHighlightTemplate = "Blur";
    public static DUAL_CLASS_STYLE dualClassStyle = DUAL_CLASS_STYLE.SIDE_BY_SIDE;
    public static int costSizeTemplate = 120;
    public static String costFontNameTemplate = null;
    public static int costFontStyleTemplate = 0;
    public static Color costColorTemplate = Color.WHITE;
    public static int attackSizeTemplate = 80;
    public static String attackFontNameTemplate = null;
    public static int attackFontStyleTemplate = 0;
    public static Color attackColorTemplate = Color.WHITE;
    public static int recruitSizeTemplate = 80;
    public static String recruitFontNameTemplate = null;
    public static int recruitFontStyleTemplate = 0;
    public static Color recruitColorTemplate = Color.WHITE;
    public String exportFolder = "cardCreator";
    String templateFolder = "legendary" + File.separator + "templates" + File.separator + LegendaryCardMaker.expansionStyle;
    int cardWidth = 750;
    int cardHeight = 1050;
    int dpi = 300;
    boolean exportImage = false;
    public boolean exportToPNG = true;
    Color teamPowerUnderlayColor = Color.BLACK;
    public int teamIconX = 54;
    public int teamIconY = 60;
    public int teamMaxWidth = 54;
    public int teamMaxHeight = 54;
    public boolean includeBlurredBGTeam = true;
    public int expandTeam = 1;
    public int teamBlurRadius = 5;
    public boolean teamBlurDouble = true;
    public int powerIconX = 54;
    public int powerIconY = 120;
    public int powerMaxWidth = 54;
    public int powerMaxHeight = 54;
    public boolean includeBlurredBGPower = true;
    public int expandPower = 1;
    public int powerBlurRadius = 5;
    public boolean powerBlurDouble = true;
    public String nameHighlight = "Blur";
    public String cardNameFontName = null;
    public int cardNameFontStyle = 0;
    public int cardNameSize = 40;
    public int cardNameMinSize = 30;
    public int cardNameY = 20;
    public Color cardNameColor = new Color(255, 186, 20);
    public boolean includeBlurredBGName = true;
    public int expandCardName = 2;
    public int cardNameBlurRadius = 5;
    public boolean cardNameBlurDouble = true;
    public String heroNameFontName = null;
    public int heroNameFontStyle = 0;
    public int heroNameSize = 33;
    public int heroNameMinSize = 30;
    public int heroNameY = 60;
    public Color heroNameColor = new Color(255, 186, 20);
    public boolean includeBlurredBGHeroName = true;
    public int expandHeroName = 2;
    public int heroNameBlurRadius = 5;
    public boolean heroNameBlurDouble = true;
    public String costFontName = null;
    public int costFontStyle = 0;
    public int costSize = 120;
    public int costX = 635;
    public int costY = 950;
    public Color costColor = Color.WHITE;
    public boolean includeBlurredBGCost = true;
    public int expandCost = 5;
    public int costBlurRadius = 5;
    public boolean costBlurDouble = false;
    public String recruitFontName = null;
    public int recruitFontStyle = 0;
    public int recruitSize = 80;
    public int recruitX = 98;
    public int recruitY = 760;
    public Color recruitColor = Color.WHITE;
    public boolean includeBlurredBGRecruit = true;
    public int expandRecruit = 3;
    public int recruitBlurRadius = 3;
    public boolean recruitBlurDouble = false;
    public String attackFontName = null;
    public int attackFontStyle = 0;
    public int attackSize = 80;
    public int attackX = 87;
    public int attackY = 917;
    public Color attackColor = Color.WHITE;
    public boolean includeBlurredBGAttack = true;
    public int expandAttack = 3;
    public int attackBlurRadius = 3;
    public boolean attackBlurDouble = false;
    public HashMap<String, Integer> costOffsets = new HashMap();
    public String textFontName = null;
    public int textFontStyle = 0;
    public int textSize = 27;
    public int textX = 154;
    public int textY = 805;
    public Color textColor = Color.BLACK;
    public boolean includeBlurredBGText = false;
    public int expandText = 0;
    public int textBlurRadius = 0;
    public boolean textBlurDouble = false;
    public double textIconHeight = 1.2;
    public double textGapHeight = 0.6;
    public double textDefaultGapHeight = 0.2;
    public int expandTextIcon = 0;
    public int textIconBlurRadius = 5;
    public boolean textIconBlurDouble = true;
    public double rarePaddingRatio = 0.06;
    public int rareBlurRadius = 25;
    public int textStartOffset = 0;
    public HeroCard card;
    public BufferedWriter bwErr = null;

    public static void resetTemplateValues() {
        cardNameSizeTemplate = 40;
        cardNameFontNameTemplate = null;
        cardNameFontStyleTemplate = 0;
        cardNameColorTemplate = new Color(255, 186, 20);
        heroNameSizeTemplate = 33;
        heroNameFontNameTemplate = null;
        heroNameFontStyleTemplate = 0;
        heroNameColorTemplate = new Color(255, 186, 20);
        abilityTextSizeTemplate = 27;
        abilityTextColorTemplate = Color.BLACK;
        abilityTextFontNameTemplate = null;
        abilityTextFontStyleTemplate = 0;
        teamPowerUnderlayColorTemplate = Color.BLACK;
        teamPowerBlurRadiusTemplate = 5;
        nameHighlightTemplate = "Blur";
        costSizeTemplate = 120;
        costFontNameTemplate = null;
        costFontStyleTemplate = 0;
        costColorTemplate = Color.WHITE;
        attackSizeTemplate = 80;
        attackFontNameTemplate = null;
        attackFontStyleTemplate = 0;
        attackColorTemplate = Color.WHITE;
        recruitSizeTemplate = 80;
        recruitFontNameTemplate = null;
        recruitFontStyleTemplate = 0;
        recruitColorTemplate = Color.WHITE;
        dualClassStyle = DUAL_CLASS_STYLE.SIDE_BY_SIDE;
    }

    public void resetTemplateValuesInstance() {
        this.cardNameSize = 40;
        this.cardNameFontName = null;
        this.cardNameFontStyle = 0;
        this.cardNameColor = new Color(255, 186, 20);
        this.heroNameSize = 33;
        this.heroNameFontName = null;
        this.heroNameFontStyle = 0;
        this.heroNameColor = new Color(255, 186, 20);
        this.textSize = 27;
        this.textColor = Color.BLACK;
        this.textFontName = null;
        this.textFontStyle = 0;
        this.teamPowerUnderlayColor = Color.BLACK;
        this.teamBlurRadius = 5;
        this.powerBlurRadius = 5;
        this.nameHighlight = "Blur";
        this.costSize = 120;
        this.costFontName = null;
        this.costFontStyle = 0;
        this.costColor = Color.WHITE;
        this.attackSize = 80;
        this.attackFontName = null;
        this.attackFontStyle = 0;
        this.attackColor = Color.WHITE;
        this.recruitSize = 80;
        this.recruitFontName = null;
        this.recruitFontStyle = 0;
        this.recruitColor = Color.WHITE;
    }

    public void loadTemplateDefaults() {
        this.cardNameSize = cardNameSizeTemplate;
        this.cardNameColor = cardNameColorTemplate;
        this.cardNameFontName = cardNameFontNameTemplate;
        this.cardNameFontStyle = cardNameFontStyleTemplate;
        this.heroNameSize = heroNameSizeTemplate;
        this.heroNameColor = heroNameColorTemplate;
        this.heroNameFontName = heroNameFontNameTemplate;
        this.heroNameFontStyle = heroNameFontStyleTemplate;
        this.textSize = abilityTextSizeTemplate;
        this.textColor = abilityTextColorTemplate;
        this.textFontName = abilityTextFontNameTemplate;
        this.textFontStyle = abilityTextFontStyleTemplate;
        this.teamPowerUnderlayColor = teamPowerUnderlayColorTemplate;
        this.teamBlurRadius = teamPowerBlurRadiusTemplate;
        this.powerBlurRadius = teamPowerBlurRadiusTemplate;
        this.nameHighlight = nameHighlightTemplate;
        this.costSize = costSizeTemplate;
        this.costColor = costColorTemplate;
        this.costFontName = costFontNameTemplate;
        this.costFontStyle = costFontStyleTemplate;
        this.attackSize = attackSizeTemplate;
        this.attackColor = attackColorTemplate;
        this.attackFontName = attackFontNameTemplate;
        this.attackFontStyle = attackFontStyleTemplate;
        this.recruitSize = recruitSizeTemplate;
        this.recruitColor = recruitColorTemplate;
        this.recruitFontName = recruitFontNameTemplate;
        this.recruitFontStyle = recruitFontStyleTemplate;
    }

    public static String generateTemplateOutputString() {
        String str = "";
        if (cardNameSizeTemplate > 0) {
            str = String.valueOf(str) + "HCTCARDNAMESIZE;" + cardNameSizeTemplate + "\n";
        }
        if (heroNameSizeTemplate > 0) {
            str = String.valueOf(str) + "HCTHERONAMESIZE;" + heroNameSizeTemplate + "\n";
        }
        if (abilityTextSizeTemplate > 0) {
            str = String.valueOf(str) + "HCTABILITYTEXTSIZE;" + abilityTextSizeTemplate + "\n";
        }
        if (cardNameColorTemplate != null) {
            str = String.valueOf(str) + "HCTCARDNAMECOLOUR;" + cardNameColorTemplate.getRGB() + "\n";
        }
        if (cardNameFontNameTemplate != null) {
            str = String.valueOf(str) + "HCTCARDNAMEFONTNAME;" + cardNameFontNameTemplate + "\n";
        }
        str = String.valueOf(str) + "HCTCARDNAMEFONTSTYLE;" + cardNameFontStyleTemplate + "\n";
        if (heroNameColorTemplate != null) {
            str = String.valueOf(str) + "HCTHERONAMECOLOUR;" + heroNameColorTemplate.getRGB() + "\n";
        }
        if (heroNameFontNameTemplate != null) {
            str = String.valueOf(str) + "HCTHERONAMEFONTNAME;" + heroNameFontNameTemplate + "\n";
        }
        str = String.valueOf(str) + "HCTHERONAMEFONTSTYLE;" + heroNameFontStyleTemplate + "\n";
        if (abilityTextColorTemplate != null) {
            str = String.valueOf(str) + "HCTABILITYTEXTCOLOUR;" + abilityTextColorTemplate.getRGB() + "\n";
        }
        if (abilityTextFontNameTemplate != null) {
            str = String.valueOf(str) + "HCTABILITYTEXTFONTNAME;" + abilityTextFontNameTemplate + "\n";
        }
        str = String.valueOf(str) + "HCTABILITYTEXTFONTSTYLE;" + abilityTextFontStyleTemplate + "\n";
        if (teamPowerUnderlayColorTemplate != null) {
            str = String.valueOf(str) + "HCTTEAMPOWERUNDERLAYCOLOUR;" + teamPowerUnderlayColorTemplate.getRGB() + "\n";
        }
        if (teamPowerBlurRadiusTemplate > 0) {
            str = String.valueOf(str) + "HCTTEAMPOWERBLURRADIUS;" + teamPowerBlurRadiusTemplate + "\n";
        }
        if (nameHighlightTemplate != null) {
            str = String.valueOf(str) + "HCTNAMEHIGHLIGHTTYPE;" + nameHighlightTemplate + "\n";
        }
        if (costSizeTemplate > 0) {
            str = String.valueOf(str) + "HCTCOSTSIZE;" + costSizeTemplate + "\n";
        }
        if (costColorTemplate != null) {
            str = String.valueOf(str) + "HCTCOSTCOLOUR;" + costColorTemplate.getRGB() + "\n";
        }
        if (costFontNameTemplate != null) {
            str = String.valueOf(str) + "HCTCOSTFONTNAME;" + costFontNameTemplate + "\n";
        }
        str = String.valueOf(str) + "HCTCOSTFONTSTYLE;" + costFontStyleTemplate + "\n";
        if (attackSizeTemplate > 0) {
            str = String.valueOf(str) + "HCTATTACKSIZE;" + attackSizeTemplate + "\n";
        }
        if (attackColorTemplate != null) {
            str = String.valueOf(str) + "HCTATTACKCOLOUR;" + attackColorTemplate.getRGB() + "\n";
        }
        if (attackFontNameTemplate != null) {
            str = String.valueOf(str) + "HCTATTACKFONTNAME;" + attackFontNameTemplate + "\n";
        }
        str = String.valueOf(str) + "HCTATTACKFONTSTYLE;" + attackFontStyleTemplate + "\n";
        if (recruitSizeTemplate > 0) {
            str = String.valueOf(str) + "HCTRECRUITSIZE;" + recruitSizeTemplate + "\n";
        }
        if (recruitColorTemplate != null) {
            str = String.valueOf(str) + "HCTRECRUITCOLOUR;" + recruitColorTemplate.getRGB() + "\n";
        }
        if (recruitFontNameTemplate != null) {
            str = String.valueOf(str) + "HCTRECRUITFONTNAME;" + recruitFontNameTemplate + "\n";
        }
        str = String.valueOf(str) + "HCTRECRUITFONTSTYLE;" + recruitFontStyleTemplate + "\n";
        str = String.valueOf(str) + "HCTDUALCLASSSTYLE;" + dualClassStyle.name();
        str = String.valueOf(str) + "\n";
        return str;
    }

    public HeroMaker() {
        this.costOffsets.put("4", -8);
        this.costOffsets.put("6", -5);
        this.costOffsets.put("X", -3);
    }

    public void setCard(HeroCard c) {
        this.card = c;
        if (this.card.nameSize > 0) {
            this.cardNameSize = this.card.nameSize;
        }
        if (this.card.heroNameSize > 0) {
            this.heroNameSize = this.card.heroNameSize;
        }
        if (this.card.abilityTextSize > 0) {
            this.textSize = this.card.abilityTextSize;
        }
    }

    public void populateHeroCard() {
        this.card = new HeroCard();
        this.card.heroName = "Swoop";
        this.card.name = "The Friendly One";
        this.card.rarity = CardRarity.COMMON;
        this.card.cardTeam = Icon.valueOf("AUTOBOT");
        this.card.cardPower = Icon.valueOf("INSTINCT");
        this.card.cost = "3";
        this.card.attack = "2";
        this.card.recruit = "3";
        this.card.abilityText = "<k>Transform <g> <r>Select a player. That player must play an <AUTOBOT> hero from their hand or discard pile that has a <COST> of 5 or less. You gain all effects of that card as if you played it. That player discards the card after this turn.";
    }

    public void populateBlankHeroCard() {
        this.card = new HeroCard();
        this.card.heroName = "Hero";
        this.card.name = "Card Name";
        this.card.rarity = CardRarity.COMMON;
        this.card.cardTeam = Icon.valueOf("NONE");
        this.card.cardPower = Icon.valueOf("NONE");
        this.card.cost = "X";
        this.card.attack = null;
        this.card.recruit = null;
        this.card.abilityText = "Card text";
    }

    public static HeroCard getBlankHeroCard() {
        HeroCard card = new HeroCard();
        card.heroName = "Hero";
        card.name = "Card Name";
        card.rarity = CardRarity.COMMON;
        card.cardTeam = Icon.valueOf("NONE");
        card.cardPower = Icon.valueOf("NONE");
        card.cost = "X";
        card.attack = null;
        card.recruit = null;
        card.abilityText = "Card text";
        return card;
    }

    @Override
    public BufferedImage generateCard() {
        int width;
        int yOrigin;
        LineMetrics lm;
        ImageIcon ii;
        BufferedImage bi1;
        int stringLength;
        Font font;
        Graphics2D g2;
        ImageIcon ii2;
        BufferedImage bi;
        int type = 2;
        if (this.exportToPNG) {
            type = 2;
        }
        BufferedImage image = new BufferedImage(this.cardWidth, this.cardHeight, type);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.card.imagePath != null) {
            String imagePath = this.card.imagePath;
            if (!imagePath.contains(File.separator) && LegendaryCardMakerFrame.lcmf.lcm.currentFile != null) {
                imagePath = String.valueOf(new File(LegendaryCardMakerFrame.lcmf.lcm.currentFile).getParent()) + File.separator + this.card.imagePath;
            }
            bi = this.resizeImage(new ImageIcon(imagePath), this.card.imageZoom);
            g.drawImage((Image)bi, this.card.imageOffsetX, this.card.imageOffsetY, null);
        }
        if (this.card.rarity != null && this.card.rarity.equals((Object)CardRarity.COMMON)) {
            ii2 = null;
            ii2 = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "hero_common" + File.separator + "back_text.png");
            g.drawImage((Image)this.resizeImage(ii2, this.cardWidth, this.cardHeight), 0, 0, null);
            if (this.card.cardPower == null || this.card.cardPower != null && this.card.cardPower.equals(Icon.valueOf("NONE"))) {
                ii2 = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "hero_common" + File.separator + "back_grey.png");
                g.drawImage((Image)this.resizeImage(ii2, this.cardWidth, this.cardHeight), 0, 0, null);
            } else if (this.card.cardPower2 != null && this.card.cardPower != null && !this.card.cardPower2.equals(Icon.valueOf("NONE"))) {
                ii2 = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "hero_common" + File.separator + "back_" + this.card.cardPower2.toString() + ".png");
                g.drawImage((Image)this.resizeImage(ii2, this.cardWidth, this.cardHeight), 0, 0, null);
                ii2 = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "hero_common" + File.separator + "back_" + this.card.cardPower.toString() + ".png");
                bi = this.getFadedBackground(ii2);
                g.drawImage((Image)this.resizeImage(new ImageIcon(bi), this.cardWidth, this.cardHeight), 0, 0, null);
            } else {
                ii2 = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "hero_common" + File.separator + "back_" + this.card.cardPower.toString() + ".png");
                g.drawImage((Image)this.resizeImage(ii2, this.cardWidth, this.cardHeight), 0, 0, null);
            }
        }
        if (this.card.rarity != null && this.card.rarity.equals((Object)CardRarity.UNCOMMON)) {
            ii2 = null;
            ii2 = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "hero_uncommon" + File.separator + "back_text.png");
            g.drawImage((Image)this.resizeImage(ii2, this.cardWidth, this.cardHeight), 0, 0, null);
            if (this.card.cardPower != null && this.card.cardPower.equals(Icon.valueOf("NONE"))) {
                ii2 = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "hero_uncommon" + File.separator + "back_grey.png");
                g.drawImage((Image)this.resizeImage(ii2, this.cardWidth, this.cardHeight), 0, 0, null);
            } else if (this.card.cardPower2 != null && this.card.cardPower != null && !this.card.cardPower2.equals(Icon.valueOf("NONE"))) {
                ii2 = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "hero_uncommon" + File.separator + "back_" + this.card.cardPower2.toString() + ".png");
                g.drawImage((Image)this.resizeImage(ii2, this.cardWidth, this.cardHeight), 0, 0, null);
                ii2 = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "hero_uncommon" + File.separator + "back_" + this.card.cardPower.toString() + ".png");
                bi = this.getFadedBackground(ii2);
                g.drawImage((Image)this.resizeImage(new ImageIcon(bi), this.cardWidth, this.cardHeight), 0, 0, null);
            } else {
                ii2 = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "hero_uncommon" + File.separator + "back_" + this.card.cardPower.toString() + ".png");
                g.drawImage((Image)this.resizeImage(ii2, this.cardWidth, this.cardHeight), 0, 0, null);
            }
        }
        if (this.card.rarity != null && this.card.rarity.equals((Object)CardRarity.RARE)) {
            ii2 = null;
            if (new File(String.valueOf(this.templateFolder) + File.separator + "hero_rare" + File.separator + "back_text.png").exists()) {
                ii2 = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "hero_rare" + File.separator + "back_text.png");
                g.drawImage((Image)this.resizeImage(ii2, this.cardWidth, this.cardHeight), 0, 0, null);
            }
        }
        if (this.nameHighlight != null && this.nameHighlight.equals("Banner")) {
            BufferedImage bi2 = new BufferedImage(this.cardWidth, this.cardHeight, 2);
            Graphics g22 = bi2.getGraphics();
            Font font2 = null;
            try {
                font2 = Font.createFont(0, new File("Percolator.otf"));
                font2 = font2.deriveFont((float)this.cardNameSize);
                g22.setFont(font2);
            }
            catch (Exception e) {
                e.printStackTrace();
                font2 = new Font("Percolator", 0, this.cardNameSize);
                g22.setFont(font2);
            }
            FontMetrics metrics = g22.getFontMetrics(font2);
            int nameAscent = (int)metrics.getLineMetrics(this.card.name.toUpperCase(), g22).getAscent();
            int nameDescent = (int)metrics.getLineMetrics(this.card.name.toUpperCase(), g22).getDescent();
            try {
                font2 = Font.createFont(0, new File("Percolator.otf"));
                font2 = font2.deriveFont((float)this.heroNameSize);
                g22.setFont(font2);
            }
            catch (Exception e) {
                e.printStackTrace();
                font2 = new Font("Percolator", 0, this.heroNameSize);
                g22.setFont(font2);
            }
            g22.setFont(font2);
            metrics = g22.getFontMetrics(font2);
            int heroDescent = (int)metrics.getLineMetrics(this.card.name.toUpperCase(), g22).getDescent();
            int bannerHeight = this.heroNameY + heroDescent - (this.cardNameY - nameAscent);
            g22.setColor(Color.black);
            g22.fillRect(this.cardWidth / 2, this.cardNameY - this.getPercentage(this.cardHeight, 0.005), this.getPercentage(this.cardWidth, 0.15), bannerHeight += this.getPercentage(this.cardHeight, 0.01));
            MotionBlurOp op = new MotionBlurOp();
            op.setDistance(200.0f);
            bi2 = op.filter(bi2, null);
            this.makeTransparent(bi2, 0.8);
            g.drawImage((Image)bi2, 0, 0, null);
            AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
            tx.translate(-bi2.getWidth(null), 0.0);
            AffineTransformOp aop = new AffineTransformOp(tx, 1);
            bi2 = aop.filter(bi2, null);
            g.drawImage((Image)bi2, 0, 0, null);
            g22.dispose();
        }
        int cardNameEndPos = 0;
        if (this.card.name != null) {
            bi = new BufferedImage(this.cardWidth, this.cardHeight, 2);
            g2 = this.getGraphics(bi);
            g2.setColor(this.cardNameColor);
            font = null;
            try {
                font = Font.createFont(0, new File("Percolator.otf"));
                font = font.deriveFont((float)this.cardNameSize);
                g2.setFont(font);
            }
            catch (Exception e) {
                e.printStackTrace();
                font = new Font("Percolator", 0, this.cardNameSize);
                g2.setFont(font);
            }
            if (this.cardNameFontName != null) {
                font = new Font(this.cardNameFontName, this.cardNameFontStyle, this.cardNameSize);
                g2.setFont(font);
            }
            FontMetrics metrics = g2.getFontMetrics(font);
            g2 = this.setGraphicsHints(g2);
            int stringLength2 = SwingUtilities.computeStringWidth(metrics, this.card.name.toUpperCase());
            int x = this.cardWidth / 2 - stringLength2 / 2;
            LineMetrics lm2 = metrics.getLineMetrics(this.card.name.toUpperCase(), g2);
            g2.drawString(this.card.name.toUpperCase(), x, this.cardNameY + (int)lm2.getAscent());
            if (this.includeBlurredBGName && this.nameHighlight != null && this.nameHighlight.equals("Blur")) {
                this.drawUnderlay(bi, g2, type, 0, 0, this.cardNameBlurRadius, this.cardNameBlurDouble, this.expandCardName, Color.black);
            }
            g2.drawString(this.card.name.toUpperCase(), x, this.cardNameY + (int)lm2.getAscent());
            cardNameEndPos = this.cardNameY + (int)lm2.getHeight();
            g.drawImage((Image)bi, 0, 0, null);
            g2.dispose();
        }
        if (this.card.heroName != null) {
            bi = new BufferedImage(this.cardWidth, this.cardHeight, 2);
            g2 = this.getGraphics(bi);
            g2.setColor(this.heroNameColor);
            font = null;
            try {
                font = Font.createFont(0, new File("Percolator.otf"));
                font = font.deriveFont((float)this.heroNameSize);
                g2.setFont(font);
            }
            catch (Exception e) {
                e.printStackTrace();
                font = new Font("Percolator", 0, this.heroNameSize);
                g2.setFont(font);
            }
            if (this.heroNameFontName != null) {
                font = new Font(this.heroNameFontName, this.heroNameFontStyle, this.heroNameSize);
            }
            g2.setFont(font);
            FontMetrics metrics = g2.getFontMetrics(font);
            LineMetrics lm3 = metrics.getLineMetrics(this.card.heroName.toUpperCase(), g2);
            g2 = this.setGraphicsHints(g2);
            stringLength = SwingUtilities.computeStringWidth(metrics, this.card.heroName.toUpperCase());
            int x = this.cardWidth / 2 - stringLength / 2;
            int modifiedY = this.heroNameY;
            if (cardNameEndPos > this.heroNameY) {
                modifiedY = cardNameEndPos;
            }
            g2.drawString(this.card.heroName.toUpperCase(), x, modifiedY + (int)lm3.getAscent());
            if (this.includeBlurredBGHeroName && this.nameHighlight != null && this.nameHighlight.equals("Blur")) {
                this.drawUnderlay(bi, g2, type, 0, 0, this.heroNameBlurRadius, this.heroNameBlurDouble, this.expandHeroName, Color.black);
            }
            g2.drawString(this.card.heroName.toUpperCase(), x, modifiedY + (int)lm3.getAscent());
            g.drawImage((Image)bi, 0, 0, null);
            g2.dispose();
        }
        if (this.card.cardTeam != null && this.card.cardTeam.getImagePath() != null) {
            if (this.card.cardTeam2 != null && this.card.cardTeam != null && !this.card.cardTeam2.equals(Icon.valueOf("NONE"))) {
                bi1 = this.getIcon(this.card.cardTeam, this.teamMaxWidth, this.teamMaxHeight);
                BufferedImage bi2 = this.getIcon(this.card.cardTeam2, this.teamMaxWidth, this.teamMaxHeight);
                int x = this.teamIconX - bi1.getWidth() / 2;
                int y = this.teamIconY - bi1.getWidth() / 2;
                if (this.includeBlurredBGTeam) {
                    this.drawUnderlay(bi1, g, type, x, y, this.teamBlurRadius, this.teamBlurDouble, this.expandTeam, this.teamPowerUnderlayColor);
                    this.drawUnderlay(bi2, g, type, x + bi1.getWidth(), y, this.teamBlurRadius, this.teamBlurDouble, this.expandTeam, this.teamPowerUnderlayColor);
                }
                g.drawImage((Image)bi1, x, y, null);
                g.drawImage((Image)bi2, x + bi1.getWidth(), y, null);
            } else {
                bi = this.getIcon(this.card.cardTeam, this.teamMaxWidth, this.teamMaxHeight);
                int x = this.teamIconX - bi.getWidth() / 2;
                int y = this.teamIconY - bi.getWidth() / 2;
                if (this.includeBlurredBGTeam) {
                    this.drawUnderlay(bi, g, type, x, y, this.teamBlurRadius, this.teamBlurDouble, this.expandTeam, this.teamPowerUnderlayColor);
                }
                g.drawImage((Image)bi, x, y, null);
            }
        }
        if (this.card.cardPower != null && this.card.cardPower.getImagePath() != null) {
            if (this.card.cardPower2 != null && this.card.cardPower != null && !this.card.cardPower2.equals(Icon.valueOf("NONE"))) {
                bi1 = this.getIcon(this.card.cardPower, this.powerMaxWidth, this.powerMaxHeight);
                BufferedImage bi2 = this.getIcon(this.card.cardPower2, this.powerMaxWidth, this.powerMaxHeight);
                int x = this.powerIconX - bi1.getWidth() / 2;
                int y = this.powerIconY - bi1.getWidth() / 2;
                int offset = 0;
                int yoffset = 0;
                if (dualClassStyle.equals((Object)DUAL_CLASS_STYLE.SIDE_BY_SIDE)) {
                    offset = bi1.getWidth();
                }
                if (dualClassStyle.equals((Object)DUAL_CLASS_STYLE.HALF_AND_HALF)) {
                    bi1 = this.clearHalfImage(bi1, true);
                    bi2 = this.clearHalfImage(bi2, false);
                }
                if (dualClassStyle.equals((Object)DUAL_CLASS_STYLE.TOP_AND_BOTTOM)) {
                    yoffset = bi1.getHeight();
                }
                if (this.includeBlurredBGTeam) {
                    this.drawUnderlay(bi1, g, type, x, y, this.powerBlurRadius, this.powerBlurDouble, this.expandPower, this.teamPowerUnderlayColor);
                    this.drawUnderlay(bi2, g, type, x + offset, y + yoffset, this.powerBlurRadius, this.powerBlurDouble, this.expandPower, this.teamPowerUnderlayColor);
                }
                g.drawImage((Image)bi1, x, y, null);
                g.drawImage((Image)bi2, x + offset, y + yoffset, null);
            } else {
                bi = this.getIcon(this.card.cardPower, this.powerMaxWidth, this.powerMaxHeight);
                int x = this.powerIconX - bi.getWidth() / 2;
                int y = this.powerIconY - bi.getWidth() / 2;
                if (this.includeBlurredBGPower) {
                    this.drawUnderlay(bi, g, type, x, y, this.powerBlurRadius, this.powerBlurDouble, this.expandPower, this.teamPowerUnderlayColor);
                }
                g.drawImage((Image)bi, x, y, null);
            }
        }
        if (this.card.recruit != null) {
            ii = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "hero_common" + File.separator + "attr_recruit.png");
            g.drawImage((Image)this.resizeImage(ii, this.cardWidth, this.cardHeight), 0, 0, null);
            BufferedImage bi3 = new BufferedImage(this.cardWidth, this.cardHeight, 2);
            Graphics2D g23 = this.getGraphics(bi3);
            g23.setColor(this.recruitColor);
            Font font3 = null;
            try {
                font3 = Font.createFont(0, new File("Sylfaen.ttf"));
                font3 = font3.deriveFont((float)this.recruitSize);
            }
            catch (Exception e) {
                e.printStackTrace();
                font3 = new Font("Sylfaen", 0, this.recruitSize);
            }
            if (this.recruitFontName != null) {
                font3 = new Font(this.recruitFontName, this.recruitFontStyle, this.recruitSize);
            }
            g23.setFont(font3);
            FontMetrics metrics = g23.getFontMetrics(font3);
            stringLength = SwingUtilities.computeStringWidth(metrics, this.card.recruit.toUpperCase());
            int x = this.recruitX - stringLength / 2;
            lm = metrics.getLineMetrics(this.card.recruit, g23);
            int recruitYModified = this.recruitY + (int)((lm.getAscent() - lm.getDescent()) / 2.0f);
            g23 = this.setGraphicsHints(g23);
            g23.drawString(this.card.recruit.toUpperCase(), x, recruitYModified);
            if (this.includeBlurredBGRecruit) {
                this.drawUnderlay(bi3, g23, type, 0, 0, this.recruitBlurRadius, this.recruitBlurDouble, this.expandRecruit, Color.black);
            }
            g23.drawString(this.card.recruit.toUpperCase(), x, recruitYModified);
            g.drawImage((Image)bi3, 0, 0, null);
            g23.dispose();
        }
        if (this.card.attack != null) {
            ii = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "hero_common" + File.separator + "attr_attack.png");
            g.drawImage((Image)this.resizeImage(ii, this.cardWidth, this.cardHeight), 0, 0, null);
            BufferedImage bi4 = new BufferedImage(this.cardWidth, this.cardHeight, 2);
            Graphics2D g24 = this.getGraphics(bi4);
            g24.setColor(this.attackColor);
            Font font4 = null;
            try {
                font4 = Font.createFont(0, new File("Sylfaen.ttf"));
                font4 = font4.deriveFont((float)this.attackSize);
            }
            catch (Exception e) {
                e.printStackTrace();
                font4 = new Font("Sylfaen", 0, this.attackSize);
            }
            if (this.attackFontName != null) {
                font4 = new Font(this.attackFontName, this.attackFontStyle, this.attackSize);
            }
            g24.setFont(font4);
            FontMetrics metrics = g24.getFontMetrics(font4);
            stringLength = SwingUtilities.computeStringWidth(metrics, this.card.attack.toUpperCase());
            int x = this.attackX - stringLength / 2;
            g24 = this.setGraphicsHints(g24);
            lm = metrics.getLineMetrics(this.card.attack, g24);
            int attackYModified = this.attackY + (int)((lm.getAscent() - lm.getDescent()) / 2.0f);
            g24.drawString(this.card.attack.toUpperCase(), x, attackYModified);
            if (this.includeBlurredBGAttack) {
                this.drawUnderlay(bi4, g24, type, 0, 0, this.attackBlurRadius, this.attackBlurDouble, this.expandAttack, Color.black);
            }
            g24.drawString(this.card.attack.toUpperCase(), x, attackYModified);
            g.drawImage((Image)bi4, 0, 0, null);
            g24.dispose();
        }
        if (this.card.abilityText != null) {
            BufferedImage bi5;
            block98: {
                ii = null;
                BufferedImage overlay = null;
                if (this.card.rarity != null && this.card.rarity.equals((Object)CardRarity.COMMON)) {
                    ii = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "hero_common" + File.separator + "back_text_overlay.png");
                    overlay = this.resizeImage(ii, this.cardWidth, this.cardHeight);
                } else if (this.card.rarity != null && this.card.rarity.equals((Object)CardRarity.UNCOMMON)) {
                    ii = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "hero_uncommon" + File.separator + "back_text_overlay.png");
                    overlay = this.resizeImage(ii, this.cardWidth, this.cardHeight);
                } else if (this.card.rarity != null && this.card.rarity.equals((Object)CardRarity.RARE)) {
                    ii = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "hero_rare" + File.separator + "back_text_overlay.png");
                    overlay = this.resizeImage(ii, this.cardWidth, this.cardHeight);
                }
                bi5 = new BufferedImage(this.cardWidth, this.cardHeight, 2);
                Graphics2D g25 = this.getGraphics(bi5);
                g25.setColor(this.textColor);
                try {
                    Font font5 = Font.createFont(0, new File("Swiss 721 Light Condensed.ttf"));
                    font5 = font5.deriveFont((float)this.textSize);
                    if (this.textFontName != null) {
                        font5 = new Font(this.textFontName, this.textFontStyle, this.textSize);
                    }
                    g25.setFont(font5);
                    Font fontBold = Font.createFont(0, new File("Swiss 721 Black Condensed.ttf"));
                    fontBold = fontBold.deriveFont((float)this.textSize);
                    FontMetrics metrics = g25.getFontMetrics(font5);
                    g25 = this.setGraphicsHints(g25);
                    int x = this.textX;
                    int y = this.textY;
                    int xOrigin = this.textX;
                    int xEnd = this.textX;
                    yOrigin = this.textY;
                    width = overlay.getWidth();
                    int height = overlay.getHeight();
                    boolean done = false;
                    int xx = 0;
                    while (xx < width) {
                        int yy = 0;
                        while (yy < height) {
                            Color originalColor = new Color(overlay.getRGB(xx, yy), true);
                            if (originalColor.getAlpha() > 0 && !done) {
                                x = xx;
                                y = yy + metrics.getHeight();
                                xOrigin = xx;
                                yOrigin = yy;
                                done = true;
                            }
                            ++yy;
                        }
                        ++xx;
                    }
                    int yOffset = 0;
                    if (this.card.rarity.equals((Object)CardRarity.RARE)) {
                        yOffset = this.getYOffset(g25, font5, fontBold, x, xOrigin, xEnd, y, yOrigin, metrics, overlay);
                    }
                    yOrigin = yOrigin + this.textStartOffset + yOffset;
                    y = y + this.textStartOffset + yOffset;
                    done = false;
                    int xx2 = width - 1;
                    while (xx2 >= 0) {
                        int yy = 0;
                        while (yy < height) {
                            Color originalColor = new Color(overlay.getRGB(xx2, yy), true);
                            if (originalColor.getAlpha() > 0 && !done) {
                                xEnd = xx2;
                                done = true;
                            }
                            ++yy;
                        }
                        --xx2;
                    }
                    List<WordDefinition> words = WordDefinition.getWordDefinitionList(this.card.abilityText);
                    for (WordDefinition wd : words) {
                        Color color;
                        String s = wd.word;
                        String spaceChar = "";
                        if (wd.space) {
                            spaceChar = " ";
                        }
                        if (s.startsWith("<k>")) {
                            g25.setFont(fontBold);
                            metrics = g25.getFontMetrics(fontBold);
                            g25 = this.setGraphicsHints(g25);
                            s = s.replace("<k>", "");
                            continue;
                        }
                        if (s.startsWith("<r>")) {
                            g25.setFont(font5);
                            metrics = g25.getFontMetrics(font5);
                            g25 = this.setGraphicsHints(g25);
                            s = s.replace("<r>", "");
                            continue;
                        }
                        boolean gap = false;
                        if (s.equals("<g>")) {
                            gap = true;
                        }
                        Icon icon = this.isIcon(s);
                        if (gap) {
                            x = xOrigin;
                            y += g25.getFontMetrics(font5).getHeight() + this.getPercentage(g25.getFontMetrics(font5).getHeight(), this.textGapHeight);
                            continue;
                        }
                        if (icon == null) {
                            int stringLength3 = SwingUtilities.computeStringWidth(metrics, s);
                            color = null;
                            try {
                                color = new Color(overlay.getRGB(x + stringLength3, y), true);
                            }
                            catch (ArrayIndexOutOfBoundsException e) {
                                color = new Color(overlay.getRGB(0, 0), true);
                            }
                            if (color.getAlpha() == 0) {
                                if (x > xEnd) {
                                    xEnd = x;
                                }
                                x = xOrigin;
                                y += g25.getFontMetrics(font5).getHeight() + this.getPercentage(g25.getFontMetrics(font5).getHeight(), this.textDefaultGapHeight);
                            }
                            g25.drawString(String.valueOf(s) + " ", x, y);
                            x += stringLength3 + SwingUtilities.computeStringWidth(metrics, spaceChar);
                            continue;
                        }
                        if (icon == null) continue;
                        BufferedImage i = this.getIconMaxHeight(icon, this.getPercentage(metrics.getHeight(), this.textIconHeight));
                        color = new Color(overlay.getRGB(x + i.getWidth(), y + i.getHeight()), true);
                        if (color.getAlpha() == 0) {
                            if (x > xEnd) {
                                xEnd = x;
                            }
                            x = xOrigin;
                            y += g25.getFontMetrics(font5).getHeight() + this.getPercentage(g25.getFontMetrics(font5).getHeight(), this.textDefaultGapHeight);
                        }
                        double offsetRatio = this.textIconHeight - 1.0;
                        int offset = this.getPercentage(i.getHeight(), offsetRatio);
                        int modifiedY = y - i.getHeight() + offset;
                        if (icon.isUnderlayMinimized()) {
                            this.drawUnderlay(i, g25, 2, x, modifiedY, this.textIconBlurRadius, this.textIconBlurDouble, this.expandTextIcon, Color.black);
                        }
                        g25.drawImage((Image)i, x, modifiedY, null);
                        x += i.getWidth() + SwingUtilities.computeStringWidth(metrics, spaceChar);
                    }
                    if (this.card.rarity.equals((Object)CardRarity.RARE)) {
                        int padding = this.getPercentage(xEnd - xOrigin, this.rarePaddingRatio);
                        BufferedImage blurBG = this.createRareBacking(xOrigin - padding, (yOrigin += metrics.getHeight() / 3) - padding, xEnd + padding, y + padding);
                        blurBG = this.makeTransparent(blurBG, 0.85);
                        blurBG = this.blurImage(blurBG, g25, this.rareBlurRadius);
                        g.drawImage((Image)blurBG, 0, 0, null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.bwErr == null) break block98;
                    try {
                        this.bwErr.write(e.getMessage());
                        StackTraceElement[] y = e.getStackTrace();
                        int x = y.length;
                        int metrics = 0;
                        while (metrics < x) {
                            StackTraceElement s = y[metrics];
                            this.bwErr.write(s.toString());
                            ++metrics;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            g.drawImage((Image)bi5, 0, 0, null);
        }
        if (this.card.cost != null) {
            ii = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "hero_common" + File.separator + "back_cost.png");
            g.drawImage((Image)this.resizeImage(ii, this.cardWidth, this.cardHeight), 0, 0, null);
            BufferedImage bi6 = new BufferedImage(this.cardWidth, this.cardHeight, 2);
            Graphics2D g26 = this.getGraphics(bi6);
            g26.setColor(this.costColor);
            Font font6 = null;
            try {
                font6 = Font.createFont(0, new File("Percolator.otf"));
                font6 = font6.deriveFont(120.0f);
                g26.setFont(font6);
            }
            catch (Exception e) {
                e.printStackTrace();
                font6 = new Font("Percolator", 0, 120);
                g26.setFont(font6);
            }
            FontMetrics metrics = g26.getFontMetrics(font6);
            int originalHeight = metrics.getHeight();
            try {
                font6 = Font.createFont(0, new File("Sylfaen.ttf"));
                font6 = font6.deriveFont((float)this.costSize);
            }
            catch (Exception e) {
                e.printStackTrace();
                font6 = new Font("Sylfaen", 0, this.costSize);
            }
            if (this.costFontName != null) {
                font6 = new Font(this.costFontName, this.costFontStyle, this.costSize);
            }
            g26.setFont(font6);
            metrics = g26.getFontMetrics(font6);
            int stringLength4 = SwingUtilities.computeStringWidth(metrics, this.card.cost.toUpperCase());
            int newHeight = metrics.getHeight();
            g26 = this.setGraphicsHints(g26);
            Integer offset = this.costOffsets.get("");
            int primitiveOffset = 0;
            char[] cArray = this.card.cost.toCharArray();
            width = cArray.length;
            yOrigin = 0;
            while (yOrigin < width) {
                char c = cArray[yOrigin];
                offset = this.costOffsets.get("" + c);
                if (offset != null) {
                    double percentage = (double)newHeight / (double)originalHeight;
                    primitiveOffset += this.getPercentage(offset, percentage);
                }
                ++yOrigin;
            }
            int x = this.costX - stringLength4 / 2 + primitiveOffset;
            LineMetrics lm4 = metrics.getLineMetrics(this.card.cost, g26);
            int costYModified = this.costY + (int)((lm4.getAscent() - lm4.getDescent()) / 2.0f);
            g26.drawString(this.card.cost.toUpperCase(), x, costYModified);
            if (this.includeBlurredBGCost) {
                this.drawUnderlay(bi6, g26, type, 0, 0, this.costBlurRadius, this.costBlurDouble, this.expandCost, Color.black);
            }
            g26.drawString(this.card.cost.toUpperCase(), x, costYModified);
            bi6 = this.blurImage(bi6, g26, 2);
            g.drawImage((Image)bi6, 0, 0, null);
            g26.dispose();
        }
        if (this.exportImage) {
            this.exportImage(image);
        }
        g.dispose();
        return image;
    }

    public void exportImage(BufferedImage image) {
        try {
            if (this.exportToPNG) {
                File newFile = new File(String.valueOf(this.exportFolder) + File.separator + this.card.getCardName(this.exportFolder) + ".png");
                this.exportToPNG(image, newFile);
            } else {
                File newFile = new File(String.valueOf(this.exportFolder) + File.separator + this.card.getCardName(this.exportFolder) + ".jpg");
                this.exportToJPEG(image, newFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void exportToJPEG(BufferedImage image, File newFile) throws Exception {
        System.out.println("Exporting: " + newFile.getName());
        BufferedImage bi = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        Graphics g = bi.getGraphics();
        g.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
        g.dispose();
        File dir = new File(this.exportFolder);
        dir.mkdirs();
        ImageIO.write((RenderedImage)bi, "jpeg", newFile);
    }

    public void exportToPNG(BufferedImage image, File newFile) throws Exception {
        System.out.println("Exporting: " + newFile.getName());
        ImageIO.write((RenderedImage)image, "png", newFile);
    }

    public BufferedImage getIcon(Icon icon, int maxWidth, int maxHeight) {
        ImageIcon ii = new ImageIcon(icon.getImagePath());
        double r = 1.0;
        double rX = (double)maxWidth / (double)ii.getIconWidth();
        double rY = (double)maxHeight / (double)ii.getIconHeight();
        r = rY < rX ? rY : rX;
        return this.resizeImage(ii, r);
    }

    public BufferedImage getIconMaxHeight(Icon icon, int maxHeight) {
        ImageIcon ii = new ImageIcon(icon.getImagePath());
        double r = (double)maxHeight / (double)ii.getIconHeight();
        return this.resizeImage(ii, r);
    }

    public int getPercentageValue(int value, int max) {
        return (int)Math.round((double)value / (double)max * 100.0);
    }

    public int getPercentage(int size, double scale) {
        return (int)((double)size * scale);
    }

    public BufferedImage resizeImage(ImageIcon imageIcon, double scale) {
        int w = (int)((double)imageIcon.getIconWidth() * scale);
        int h = (int)((double)imageIcon.getIconHeight() * scale);
        int type = 2;
        if (w <= 0 || h <= 0) {
            return null;
        }
        BufferedImage image = new BufferedImage(w, h, type);
        Graphics2D g = this.getGraphics(image);
        g.drawImage(imageIcon.getImage(), 0, 0, w, h, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    public BufferedImage resizeImage(ImageIcon imageIcon, int width, int height) {
        int type = 2;
        BufferedImage image = new BufferedImage(width, height, type);
        Graphics2D g = this.getGraphics(image);
        g.drawImage(imageIcon.getImage(), 0, 0, width, height, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    public static ConvolveOp getGaussianBlurFilter(int radius, boolean horizontal) {
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        int size = radius * 2 + 1;
        float[] data = new float[size];
        float sigma = (float)radius / 3.0f;
        float twoSigmaSquare = 2.0f * sigma * sigma;
        float sigmaRoot = (float)Math.sqrt((double)twoSigmaSquare * Math.PI);
        float total = 0.0f;
        int i = -radius;
        while (i <= radius) {
            float distance = i * i;
            int index = i + radius;
            data[index] = (float)Math.exp(-distance / twoSigmaSquare) / sigmaRoot;
            total += data[index];
            ++i;
        }
        i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / total;
        }
        Kernel kernel = null;
        kernel = horizontal ? new Kernel(size, 1, data) : new Kernel(1, size, data);
        return new ConvolveOp(kernel, 1, null);
    }

    private BufferedImage blackoutImage(BufferedImage image, Color blackoutColor) {
        int width = image.getWidth();
        int height = image.getHeight();
        int xx = 0;
        while (xx < width) {
            int yy = 0;
            while (yy < height) {
                Color originalColor = new Color(image.getRGB(xx, yy), true);
                if (originalColor.getAlpha() > 0) {
                    image.setRGB(xx, yy, blackoutColor.getRGB());
                }
                ++yy;
            }
            ++xx;
        }
        return image;
    }

    private void drawUnderlay(BufferedImage bi, Graphics2D g, int type, int x, int y, int blurRadius, boolean doubleBlur, int expandBlackout, Color underlayColour) {
        BufferedImage blackout = new BufferedImage(this.cardWidth, this.cardHeight, type);
        this.getGraphics(blackout).drawImage((Image)bi, x, y, null);
        blackout = this.blackoutImage(blackout, this.teamPowerUnderlayColor);
        if (expandBlackout > 0) {
            blackout = this.expandBlackout(blackout, expandBlackout, underlayColour);
        }
        if (blurRadius > 0) {
            GaussianFilter op = new GaussianFilter(blurRadius);
            BufferedImage bi2 = op.filter(blackout, null);
            g.drawImage((Image)bi2, 0, 0, null);
            if (doubleBlur) {
                BufferedImage bi3 = op.filter(bi2, null);
                g.drawImage((Image)bi3, 0, 0, null);
            }
        } else {
            g.drawImage((Image)blackout, 0, 0, null);
        }
    }

    private BufferedImage blurImage(BufferedImage bi, Graphics g, int blurRadius) {
        if (blurRadius > 0) {
            GaussianFilter op = new GaussianFilter(blurRadius);
            BufferedImage bi2 = op.filter(bi, null);
            return bi2;
        }
        return bi;
    }

    private BufferedImage expandBlackout(BufferedImage image, int expandBlackout, Color blackoutColor) {
        BufferedImage expand = new BufferedImage(this.cardWidth, this.cardHeight, 2);
        int width = image.getWidth();
        int height = image.getHeight();
        int xx = 0;
        while (xx < width) {
            int yy = 0;
            while (yy < height) {
                Color originalColor = new Color(image.getRGB(xx, yy), true);
                if (originalColor.getAlpha() > 0) {
                    int i = expandBlackout;
                    while (i > 0) {
                        try {
                            expand.setRGB(xx, yy - i, blackoutColor.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            expand.setRGB(xx, yy + i, blackoutColor.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            expand.setRGB(xx - i, yy, blackoutColor.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            expand.setRGB(xx + i, yy, blackoutColor.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (i == 1) {
                            try {
                                expand.setRGB(xx - i, yy - i, blackoutColor.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                expand.setRGB(xx - i, yy + i, blackoutColor.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                expand.setRGB(xx + i, yy - i, blackoutColor.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                expand.setRGB(xx + i, yy + i, blackoutColor.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        --i;
                    }
                }
                ++yy;
            }
            ++xx;
        }
        return expand;
    }

    private Icon isIcon(String str) {
        block3: {
            try {
                if (str == null || str.startsWith("<") || str.endsWith(">")) break block3;
                return null;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        Icon i = Icon.valueOf(str.replace("<", "").replace(">", ""));
        return i;
    }

    private BufferedImage createRareBacking(int x, int y, int x2, int y2) {
        BufferedImage bi = new BufferedImage(this.cardWidth, this.cardHeight, 2);
        Graphics g2 = bi.getGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(x, y, x2 - x, y2 - y);
        return bi;
    }

    private BufferedImage makeTransparent(BufferedImage bi, double percent) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        int xx = 0;
        while (xx < width) {
            int yy = 0;
            while (yy < height) {
                Color originalColor = new Color(bi.getRGB(xx, yy), true);
                if (originalColor.getAlpha() > 0) {
                    int col = this.getPercentage(originalColor.getAlpha(), percent) << 24 | originalColor.getRed() << 16 | originalColor.getGreen() << 8 | originalColor.getBlue();
                    bi.setRGB(xx, yy, col);
                }
                ++yy;
            }
            ++xx;
        }
        return bi;
    }

    public BufferedImage resizeImagePS(BufferedImage bi) {
        double scale = 2.0;
        double xPadding = 0.043;
        double yPadding = 0.08;
        String exportType = "jpg";
        ImageIcon imageIcon = new ImageIcon(bi);
        int w = (int)((double)imageIcon.getIconWidth() * scale);
        int xPad = (int)((double)imageIcon.getIconWidth() * scale * xPadding);
        int fullW = w + xPad + xPad;
        int h = (int)((double)imageIcon.getIconHeight() * scale);
        int yPad = (int)((double)imageIcon.getIconHeight() * scale * yPadding);
        int fullH = h + yPad + yPad;
        int type = 2;
        if (exportType.equals("jpg")) {
            type = 1;
        }
        BufferedImage image = new BufferedImage(fullW, fullH, type);
        Graphics2D g = this.getGraphics(image);
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, fullW, fullH);
        g.drawImage(imageIcon.getImage(), xPad, yPad, w + xPad, h + yPad, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    public int getYOffset(Graphics g2, Font font, Font fontBold, int x, int xOrigin, int xEnd, int y, int yOrigin, FontMetrics metrics, BufferedImage overlay) {
        int yOffset = 0;
        boolean finished = false;
        do {
            Color originalColor;
            int yy;
            int width = overlay.getWidth();
            int height = overlay.getHeight();
            boolean done = false;
            int xx = 0;
            while (xx < width) {
                yy = 0;
                while (yy < height) {
                    originalColor = new Color(overlay.getRGB(xx, yy), true);
                    if (originalColor.getAlpha() > 0 && !done) {
                        x = xx;
                        y = yy + metrics.getHeight();
                        xOrigin = xx;
                        yOrigin = yy;
                        done = true;
                    }
                    ++yy;
                }
                ++xx;
            }
            yOrigin = yOrigin + this.textStartOffset + yOffset;
            y = y + this.textStartOffset + yOffset;
            done = false;
            xx = width - 1;
            while (xx >= 0) {
                yy = 0;
                while (yy < height) {
                    originalColor = new Color(overlay.getRGB(xx, yy), true);
                    if (originalColor.getAlpha() > 0 && !done) {
                        xEnd = xx;
                        done = true;
                    }
                    ++yy;
                }
                --xx;
            }
            List<WordDefinition> words = WordDefinition.getWordDefinitionList(this.card.abilityText);
            for (WordDefinition wd : words) {
                Color color;
                String s = wd.word;
                String spaceChar = "";
                if (wd.space) {
                    spaceChar = " ";
                }
                if (s.startsWith("<k>")) {
                    g2.setFont(fontBold);
                    metrics = g2.getFontMetrics(fontBold);
                    s = s.replace("<k>", "");
                }
                if (s.startsWith("<r>")) {
                    g2.setFont(font);
                    metrics = g2.getFontMetrics(font);
                    s = s.replace("<r>", "");
                }
                boolean gap = false;
                if (s.equals("<g>")) {
                    gap = true;
                }
                Icon icon = this.isIcon(s);
                if (gap) {
                    x = xOrigin;
                    y += g2.getFontMetrics(font).getHeight() + this.getPercentage(g2.getFontMetrics(font).getHeight(), this.textGapHeight);
                    continue;
                }
                if (icon == null) {
                    int stringLength = SwingUtilities.computeStringWidth(metrics, s);
                    color = null;
                    try {
                        color = new Color(overlay.getRGB(x + stringLength, y), true);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        color = new Color(overlay.getRGB(0, 0), true);
                    }
                    if (color.getAlpha() == 0) {
                        if (x > xEnd) {
                            xEnd = x;
                        }
                        x = xOrigin;
                        y += g2.getFontMetrics(font).getHeight() + this.getPercentage(g2.getFontMetrics(font).getHeight(), this.textDefaultGapHeight);
                    }
                    x += stringLength + SwingUtilities.computeStringWidth(metrics, spaceChar);
                    continue;
                }
                if (icon == null) continue;
                BufferedImage i = this.getIconMaxHeight(icon, this.getPercentage(metrics.getHeight(), this.textIconHeight));
                color = new Color(overlay.getRGB(x + i.getWidth(), y + i.getHeight()), true);
                if (color.getAlpha() == 0) {
                    if (x > xEnd) {
                        xEnd = x;
                    }
                    x = xOrigin;
                    y += g2.getFontMetrics(font).getHeight() + this.getPercentage(g2.getFontMetrics(font).getHeight(), this.textDefaultGapHeight);
                }
                double offsetRatio = this.textIconHeight - 1.0;
                int offset = this.getPercentage(i.getHeight(), offsetRatio);
                int modifiedY = y - i.getHeight() + offset;
                x += i.getWidth() + SwingUtilities.computeStringWidth(metrics, spaceChar);
            }
            if (y >= this.getPercentage(this.cardHeight, 0.89)) {
                finished = true;
                continue;
            }
            yOffset += metrics.getHeight();
        } while (!finished);
        return yOffset;
    }

    private BufferedImage getFadedBackground(ImageIcon ii) {
        BufferedImage bi = new BufferedImage(this.cardWidth, this.cardHeight, 2);
        Graphics g = bi.getGraphics();
        g.drawImage(ii.getImage(), 0, 0, this.cardWidth, this.cardHeight, null);
        int width = bi.getWidth();
        int height = bi.getHeight();
        int fadeHeight = this.getPercentage(this.cardHeight, 0.14);
        double increment = 255.0 / (double)fadeHeight;
        int alpha = 0;
        int xx = 0;
        while (xx < width) {
            int yy = 0;
            while (yy < height) {
                Color originalColor = new Color(bi.getRGB(xx, yy), true);
                if (originalColor.getAlpha() > 0) {
                    if (yy <= this.cardHeight / 2 + fadeHeight / 2) {
                        alpha = (int)((double)(this.cardHeight / 2 + fadeHeight / 2 - yy) * increment);
                        if (alpha > 255) {
                            alpha = 255;
                        }
                    } else {
                        alpha = 0;
                    }
                    int col = alpha << 24 | originalColor.getRed() << 16 | originalColor.getGreen() << 8 | originalColor.getBlue();
                    bi.setRGB(xx, yy, col);
                }
                ++yy;
            }
            ++xx;
        }
        g.dispose();
        return bi;
    }

    private BufferedImage clearHalfImage(BufferedImage bi, boolean leftHalf) {
        Graphics2D g2D = (Graphics2D)bi.getGraphics();
        g2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
        Rectangle2D.Double rect = null;
        rect = !leftHalf ? new Rectangle2D.Double(0.0, 0.0, bi.getWidth() / 2, bi.getHeight()) : new Rectangle2D.Double(bi.getWidth() / 2, 0.0, bi.getWidth(), bi.getHeight());
        g2D.fill(rect);
        g2D.dispose();
        return bi;
    }

    private Graphics2D getGraphics(BufferedImage bi) {
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return g2;
    }

    private Graphics2D setGraphicsHints(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return g2;
    }

    public static enum DUAL_CLASS_STYLE {
        HALF_AND_HALF,
        SIDE_BY_SIDE,
        TOP_AND_BOTTOM;

    }
}

